import '../../../utils/app_utilities.dart';

class GiftCardData {
  GiftCardData({
    this.id,
    this.name,
    this.sku,
    this.sellingPrice,
    this.thumbnailImage,
    this.discount,
    this.discountType,
    this.startDate,
    this.endDate,
    this.description,
    this.status,
    this.avgRating,
    this.createdBy,
    this.updatedBy,
    this.shippingId,
  });

  dynamic id;
  String? name;
  String? sku;
  double? sellingPrice;
  String? thumbnailImage;
  double? discount;
  dynamic discountType;
  DateTime? startDate;
  DateTime? endDate;
  String? description;
  dynamic status;
  double? avgRating;
  dynamic createdBy;
  dynamic updatedBy;
  dynamic shippingId;

  factory GiftCardData.fromJson(Map<String, dynamic> json) => GiftCardData(
        id: json["id"],
        name: json["name"],
        sku: json["sku"],
        sellingPrice: double.tryParse("${json["selling_price"]??'0'}"),
        thumbnailImage: json["thumbnail_image"],
        discount: AppUtilities.convertToDouble(item: json["discount"]),
        discountType: json["discount_type"].toString(),
        startDate: json["start_date"] == null ? DateTime.now() : DateTime.parse(json["start_date"]),
        endDate: json["end_date"] == null ? DateTime.now() : DateTime.parse(json["end_date"]),
        description: json["description"],
        status: json["status"],
        avgRating: AppUtilities.convertToDouble(item:json["avg_rating"]),
        createdBy: json["created_by"],
        updatedBy: json["updated_by"],
        shippingId: json["shipping_id"],
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "name": name,
        "sku": sku,
        "selling_price": sellingPrice,
        "thumbnail_image": thumbnailImage,
        "discount": discount,
        "discount_type": discountType,
        "start_date":
            "${startDate?.year.toString().padLeft(4, '0')}-${startDate?.month.toString().padLeft(2, '0')}-${startDate?.day.toString().padLeft(2, '0')}",
        "end_date":
            "${endDate?.year.toString().padLeft(4, '0')}-${endDate?.month.toString().padLeft(2, '0')}-${endDate?.day.toString().padLeft(2, '0')}",
        "description": description,
        "status": status,
        "avg_rating": avgRating,
        "created_by": createdBy,
        "updated_by": updatedBy,
        "shipping_id": shippingId,
      };
}
